---@meta

---@class FStateTreeAIActionTaskBase : FStateTreeAITaskBase
local FStateTreeAIActionTaskBase = {}


---@class FStateTreeAITaskBase : FStateTreeTaskBase
local FStateTreeAITaskBase = {}


---@class FStateTreeMoveToTask : FStateTreeAIActionTaskBase
local FStateTreeMoveToTask = {}


---@class FStateTreeMoveToTaskInstanceData
---@field AIController AAIController
---@field destination FVector
---@field TargetActor AActor
---@field AcceptableRadius float
---@field DestinationMoveTolerance float
---@field FilterClass TSubclassOf<UNavigationQueryFilter>
---@field bAllowStrafe boolean
---@field bAllowPartialPath boolean
---@field bTrackMovingGoal boolean
---@field bRequireNavigableEndLocation boolean
---@field bProjectGoalLocation boolean
---@field bReachTestIncludesAgentRadius boolean
---@field bReachTestIncludesGoalRadius boolean
---@field MoveToTask UAITask_MoveTo
---@field TaskOwner TScriptInterface<IGameplayTaskOwnerInterface>
local FStateTreeMoveToTaskInstanceData = {}



---@class UBTTask_RunDynamicStateTree : UBTTaskNode
---@field StateTreeRef FStateTreeReference
---@field InstanceData FStateTreeInstanceData
---@field InjectionTag FGameplayTag
local UBTTask_RunDynamicStateTree = {}



---@class UBTTask_RunStateTree : UBTTaskNode
---@field StateTreeRef FStateTreeReference
---@field InstanceData FStateTreeInstanceData
---@field Interval float
---@field RandomDeviation float
local UBTTask_RunStateTree = {}



---@class UStateTreeAIComponent : UStateTreeComponent
local UStateTreeAIComponent = {}


---@class UStateTreeAIComponentSchema : UStateTreeComponentSchema
---@field AIControllerClass TSubclassOf<AAIController>
local UStateTreeAIComponentSchema = {}



---@class UStateTreeComponent : UBrainComponent
---@field OnStateTreeRunStatusChanged FStateTreeComponentOnStateTreeRunStatusChanged
---@field StateTreeRef FStateTreeReference
---@field bStartLogicAutomatically boolean
---@field InstanceData FStateTreeInstanceData
local UStateTreeComponent = {}

---@param bInStartLogicAutomatically boolean
function UStateTreeComponent:SetStartLogicAutomatically(bInStartLogicAutomatically) end
---@param Event FStateTreeEvent
function UStateTreeComponent:SendStateTreeEvent(Event) end
---@return EStateTreeRunStatus
function UStateTreeComponent:GetStateTreeRunStatus() end


---@class UStateTreeComponentSchema : UStateTreeSchema
---@field ContextActorClass TSubclassOf<AActor>
---@field ContextActorDataDesc FStateTreeExternalDataDesc
---@field ContextDataDescs TArray<FStateTreeExternalDataDesc>
local UStateTreeComponentSchema = {}



